from __future__ import generators
import plus
import Arenas
import random
import Hazards2
import math

class ClawTop(Arenas.SuperArena):
    "The classic Battlebox replicated for the ultimate experience in real robot fighting.  Complete with Killsaws, Pulverizers, Ramrods, Spinners, Hellraisers, and Spikestrips."
    name = "Battlebox"
    preview = "BATTLEBOX_2_0/BB_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-18, 18, -46, -82)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/BATTLEBOX_2_0/arena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
                                 #(X,Y,Z), (CamSwing[Up-Down 0-1.57],CamRotate:lower#=ccw/higher#=cw), CamZoom*FieldOfView}        
        fov = 0.015
        self.AddStaticCamera("              StaticCam-Over-1", (0, 40, -63), (1.5708,0), 72*fov)
        self.AddStaticCamera("              StaticCam-Over-2", (0, 22, -63), (1.59,0), 73*fov)
        self.AddStaticCamera("              StaticCam-Angled-1", (0, 15, -30), (0.7, 3.14), 55*fov)
        self.AddStaticCamera("              StaticCam-Angled-2", (0, 15, -20), (0.4, 3.14), 50*fov)

        self.AddWatchCamera("               WatchCam-Over-1", (0, 30, -63), (6, 12, 30*fov, 20*fov))
        self.AddWatchCamera("               WatchCam-Over-2", (0, 30, -63), (6, 12, 40*fov, 30*fov))
        self.AddWatchCamera("               WatchCam-Over-3", (0, 30, -63), (6, 12, 50*fov, 40*fov))
        self.AddWatchCamera("             WatchCam-Corner-1a", (15.7, 12, -48), (6, 12, 30*fov, 20*fov))
        self.AddWatchCamera("             WatchCam-Corner-1b", (15.7, 12, -48), (6, 12, 40*fov, 30*fov))
        self.AddWatchCamera("             WatchCam-Corner-1c", (15.7, 12, -48), (6, 12, 50*fov, 40*fov))
        self.AddWatchCamera("             WatchCam-Corner-2a", (-15.8, 12, -79.5), (6, 12, 30*fov, 20*fov))
        self.AddWatchCamera("             WatchCam-Corner-2b", (-15.8, 12, -79.5), (6, 12, 40*fov, 30*fov))
        self.AddWatchCamera("             WatchCam-Corner-2c", (-15.8, 12, -79.5), (6, 12, 50*fov, 40*fov))
        self.AddWatchCamera("             Platform Cam -L", (8, 5, -40), (6, 12, 50*fov, 30*fov))
        self.AddWatchCamera("             Platform Cam -R", (-8, 5, -40), (6, 12, 50*fov, 30*fov))

        #self.AddWatchCamera(".     Watch Cam -1", (0, 30, -30), (6, 12, 50*fov, 10*fov))
        #self.AddWatchCamera(".     Watch Cam -2", (0, 30, -30), (6, 12, 30*fov, 20*fov))
        #self.AddWatchCamera(".     Watch Cam -3", (0, 30, -30), (6, 12, 30*fov, 30*fov))
        #self.AddWatchCamera(".     Low Watch Cam -4", (0, 10, -30), (6, 12, 80*fov, 10*fov))
        #self.AddWatchCamera(".     Low Watch Cam -5", (0, 10, -30), (6, 12, 50*fov, 30*fov))
        #self.AddWatchCamera(".     Low Watch Cam -6", (0, 10, -30), (6, 12, 50*fov, 30*fov))

        self.players = ()

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        #walls
        self.AddCollisionLine((-17.6, -79), (-17.6, -46.3))
        self.AddCollisionLine((-17.6, -46.3), (-12, -46.3))
        self.AddCollisionLine((-12, -46.3), (-12, -50.9))
        self.AddCollisionLine((-12, -49.3), (-9, -46.3))
        self.AddCollisionLine((-9, -46.3), (9, -46.3))
        self.AddCollisionLine((9, -46.3), (12, -49.3))
        self.AddCollisionLine((12, -50.9), (12, -46.3))
        self.AddCollisionLine((12, -46.3), (17.5, -46.3))
        self.AddCollisionLine((17.5, -46.3), (17.5, -79))
        self.AddCollisionLine((17.5, -79), (14.8, -81.4))
        self.AddCollisionLine((14.8, -81.4), (-15.1, -81.4))
        self.AddCollisionLine((-15.1, -81.4), (-17.6, -79))
        
        #entrance ramps
        self.AddPOV(0, (-14.8, -48), (0, 1))
        self.AddPOV(1, (-14.8, -51.5), (0, 1))
        
        self.AddPOV(2, (14.8, -48), (2, 3))
        self.AddPOV(3, (14.8, -51.5), (2, 3))
        
        Arenas.SuperArena.Activate(self, on)


    def HazardsOn(self, on):
        if on:
            #RamRod stuff
            prism = self.AddPrismatic("Floor", "spikes", 0, 1, 0, 0, 0.8, 0)
            self.spikes1 = Hazards2.Spikes(prism, 80000, (-3.7, -2.2, -5.2))

            prism = self.AddPrismatic("Floor", "spikes01", 0, 1, 0, 0, 0.8, 0)
            self.spikes2 = Hazards2.Spikes(prism, 80000, (-3.7, -2.2, -5.2))

            self.AddHazard(self.spikes1)
            self.AddHazard(self.spikes2)

            self.RegisterZone("spike_zone",13)
            self.RegisterZone("spike_zone01",14)
            
            #pulverizers
            self.SetSubMaterialSound("Box35", "metal", 0.5, "Sounds\\hzd_hammer_thud.wav")
            self.SetSubMaterialSound("Box38", "metal", 0.5, "Sounds\\hzd_hammer_thud.wav")
            self.SetSubMaterialSound("Box178", "metal", 0.5, "Sounds\\hzd_hammer_thud.wav")
            self.SetSubMaterialSound("Box40", "metal", 0.5, "Sounds\\hzd_hammer_thud.wav")
            self.AddCollisionLine((-12, -49.3), (-9, -49.3))
            self.AddCollisionLine((-9, -49.3), (-9, -46.3))
            self.AddCollisionLine((12, -49.3), (9, -49.3))
            self.AddCollisionLine((9, -49.3), (9, -46.3))
            self.AddCollisionLine((-15.1, -81.4), (-15.1, -79))
            self.AddCollisionLine((-15.1, -79), (-17.6, -79))
            self.AddCollisionLine((14.8, -81.4), (14.8, -79))
            self.AddCollisionLine((14.8, -79), (17.5, -79))
            
            #killsaws
            self.SetSubMaterialSound("Cylinder06", "metal", 0.5, "Sounds\\sawblade_hits_loop.wav")
            self.SetSubMaterialSound("Cylinder03", "metal", 0.5, "Sounds\\sawblade_hits_loop.wav")
            self.SetSubMaterialSound("Cylinder04", "metal", 0.5, "Sounds\\sawblade_hits_loop.wav")
            self.SetSubMaterialSound("Cylinder09", "metal", 0.5, "Sounds\\sawblade_hits_loop.wav")
            self.SetSubMaterialSound("Cylinder05", "metal", 0.5, "Sounds\\sawblade_hits_loop.wav")
            self.SetSubMaterialSound("Cylinder07", "metal", 0.5, "Sounds\\sawblade_hits_loop.wav")
            
            #ramrods
            self.SetSubMaterialSound("spikes", "metal", 0.5, "Sounds\\hzd_spike_hit.wav")
            self.SetSubMaterialSound("spikes01", "metal", 0.5, "Sounds\\hzd_spike_hit.wav")
            
            self.AddCollisionLine((6.6, -54.5), (6.6, -52.1))
            self.AddCollisionLine((6.6, -52.1), (8.4, -52.1))
            self.AddCollisionLine((8.4, -52.1), (8.4, -54.5))
            self.AddCollisionLine((8.4, -54.5), (6.6, -54.5))
            
            self.AddPOV(4, (6.1, -55), (4, 5))
            self.AddPOV(5, (6.1, -51.6), (5, 6))
            self.AddPOV(6, (8.9, -51.6), (6, 7))
            self.AddPOV(7, (8.9, -54.9), (7, 4))
            
            self.AddCollisionLine((-8.5, -75.6), (-8.5, -73.3))
            self.AddCollisionLine((-8.5, -73.3), (-6.8, -73.3))
            self.AddCollisionLine((-6.8, -73.3), (-6.8, -75.6))
            self.AddCollisionLine((-6.8, -75.6), (-8.5, -75.6))
            
            self.AddPOV(8, (-9, -76.1), (8, 9))
            self.AddPOV(9, (-9, -72.8), (9, 10))
            self.AddPOV(10, (-6.3, -72.8), (10, 11))
            self.AddPOV(11, (-6.3, -76.1), (11, 8))
        
            #Hellraiser stuff
            hinge = self.GetHinge("Hinge01")
            self.RegisterZone("hellzone1", 0)
            # self.RegisterZone("hellzone1", 1)
            self.Hell1 = Hazards2.HellRaiser(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell1)
            
            hinge = self.GetHinge("Hinge02")
            self.RegisterZone("hellzone2", 0)
            # self.RegisterZone("hellzone2", 2)
            self.Hell2 = Hazards2.HellRaiser(hinge, (-3.049, 0.0, -6.926))
            self.AddHazard(self.Hell2)

            #Hammers            
            hinge = self.GetHinge("hammerhinge1")
            self.RegisterZone("hammerzone1", 3)
            self.Hammer1 = Hazards2.Hammer(hinge, (-16.645287, -5.585776, -80.815155))
            self.AddHazard(self.Hammer1)
            
            hinge = self.GetHinge("hammerhinge2")
            self.RegisterZone("hammerzone2", 4)
            self.Hammer2 = Hazards2.Hammer(hinge, (16.811447, -5.584379, -80.453049))
            self.AddHazard(self.Hammer2)

            hinge = self.GetHinge("hammerhinge3")
            self.RegisterZone("hammerzone3", 5)
            self.Hammer3 = Hazards2.Hammer(hinge, (10.618183, -5.584379, -47.088528))
            self.AddHazard(self.Hammer3)
            
            hinge = self.GetHinge("hammerhinge4")
            self.RegisterZone("hammerzone4", 6)
            self.Hammer4 = Hazards2.Hammer(hinge, (-10.889646, -5.584379, -47.334965))
            self.AddHazard(self.Hammer4)
            
            #saw stuff to make them pop up
            hinge = self.GetHinge("saw_hinge")
            self.RegisterZone("saw_zone", 7)
            self.Hell3 = Hazards2.Saws(hinge, (-61.100719, -6.926217, -51.718353))
            self.AddHazard(self.Hell3)

            hinge = self.GetHinge("saw_hinge01")
            self.RegisterZone("saw_zone01", 8)
            self.Hell4 = Hazards2.Saws(hinge, (-12.307423, -6.962721, -118.898499))
            self.AddHazard(self.Hell4)

            hinge = self.GetHinge("saw_hinge02")
            self.RegisterZone("saw_zone02", 9)
            self.Hell5 = Hazards2.Saws(hinge, (-12.307423, -6.962721, -133.998688))
            self.AddHazard(self.Hell5)

            hinge = self.GetHinge("saw_hinge03")
            self.RegisterZone("saw_zone03", 10)
            self.Hell6 = Hazards2.Saws(hinge, (61.017975, -6.962721, -75.991318))
            self.AddHazard(self.Hell6)

            hinge = self.GetHinge("saw_hinge04")
            self.RegisterZone("saw_zone04", 11)
            self.Hell7 = Hazards2.Saws(hinge, (12.079148, -6.962721, -8.838474))
            self.AddHazard(self.Hell7)

            hinge = self.GetHinge("saw_hinge05")
            self.RegisterZone("saw_zone05", 12)
            self.Hell8 = Hazards2.Saws(hinge, (12.108288, -6.962721, 6.281891))
            self.AddHazard(self.Hell8)
            
            self.AddCollisionLine((-11.6, -72.8), (-11.6, -70))
            self.AddCollisionLine((-11.6, -70), (-9.7, -70))
            self.AddCollisionLine((-9.7, -70), (-9.7, -72.8))
            self.AddCollisionLine((-9.7, -72.8), (-11.6, -72.8))
            
            self.AddPOV(12, (-12.1, -73.3), (12, 13))
            self.AddPOV(13, (-12.1, -69.5), (13, 14))
            self.AddPOV(14, (-9.2, -69.5), (14, 15))
            self.AddPOV(15, (-9.2, -73.3), (15, 12))
            
            self.AddCollisionLine((-11.6, -57.7), (-11.6, -54.8))
            self.AddCollisionLine((-11.6, -54.8), (-9.7, -54.8))
            self.AddCollisionLine((-9.7, -54.8), (-9.7, -57.7))
            self.AddCollisionLine((-9.7, -57.7), (-11.6, -57.7))
            
            self.AddPOV(16, (-12.1, -58.2), (16, 17))
            self.AddPOV(17, (-12.1, -54.3), (17, 18))
            self.AddPOV(18, (-9.2, -54.3), (18, 19))
            self.AddPOV(19, (-9.2, -58.2), (19, 16))
            
            self.AddCollisionLine((0, -54.3), (0, -52.2))
            self.AddCollisionLine((0, -52.2), (2.9, -52.2))
            self.AddCollisionLine((2.9, -52.2), (2.9, -54.3))
            self.AddCollisionLine((2.9, -54.3), (0, -54.3))
            
            self.AddPOV(20, (-0.5, -54.8), (20, 21))
            self.AddPOV(21, (-0.5, -51.7), (21, 22))
            self.AddPOV(22, (3.4, -51.7), (22, 23))
            self.AddPOV(23, (3.4, -54.8), (23, 20))
            
            self.AddCollisionLine((9.6, -57.7), (9.6, -54.8))
            self.AddCollisionLine((9.6, -54.8), (11.6, -54.8))
            self.AddCollisionLine((11.6, -54.8), (11.6, -57.7))
            self.AddCollisionLine((11.6, -57.7), (9.6, -57.7))
            
            self.AddPOV(24, (9.2, -58.2), (24, 25))
            self.AddPOV(25, (9.2, -54.3), (25, 26))
            self.AddPOV(26, (12.1, -54.3), (26, 27))
            self.AddPOV(27, (12.1, -58.2), (27, 24))
            
            self.AddCollisionLine((9.6, -72.8), (9.6, -70))
            self.AddCollisionLine((9.6, -70), (11.6, -70))
            self.AddCollisionLine((11.6, -70), (11.6, -72.8))
            self.AddCollisionLine((11.6, -72.8), (9.6, -72.8))
            
            self.AddPOV(28, (9.2, -73.3), (28, 29))
            self.AddPOV(29, (9.2, -69.5), (29, 30))
            self.AddPOV(30, (12.1, -69.5), (30, 31))
            self.AddPOV(31, (12.1, -73.3), (31, 28))
            
            self.AddCollisionLine((-3, -75.4), (-3, -73.4))
            self.AddCollisionLine((-3, -73.4), (-0.1, -73.4))
            self.AddCollisionLine((-0.1, -73.4), (-0.1, -75.4))
            self.AddCollisionLine((-0.1, -75.4), (-3, -75.4))
            
            self.AddPOV(32, (-3.5, -75.9), (32, 33))
            self.AddPOV(33, (-3.5, -72.9), (33, 34))
            self.AddPOV(34, (0.4, -72.9), (34, 35))
            self.AddPOV(35, (0.4, -75.9), (35, 32))

            #arena spinners
            self.spinner = self.GetHinge("spinner")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(20, 1000)
            self.spinner.Lock(False)
            self.spinner.SetDirection(-100)

            self.spinner2 = self.GetHinge("spinner2")
            self.spinner2.SetAutoLocks(False, True)
            self.spinner2.SetPowerSettings(20, 1000)
            self.spinner2.Lock(False)
            self.spinner2.SetDirection(-100)

            #saw stuff to make them spin
            self.sawspin = self.GetHinge("saws_spin")
            self.sawspin.SetAutoLocks(False, True)
            self.sawspin.SetPowerSettings(20, 1000)
            self.sawspin.Lock(False)
            self.sawspin.SetDirection(-100)

            self.sawspin2 = self.GetHinge("saws_spin01")
            self.sawspin2.SetAutoLocks(False, True)
            self.sawspin2.SetPowerSettings(20, 1000)
            self.sawspin2.Lock(False)
            self.sawspin2.SetDirection(-100)

            self.sawspin3 = self.GetHinge("saws_spin02")
            self.sawspin3.SetAutoLocks(False, True)
            self.sawspin3.SetPowerSettings(20, 1000)
            self.sawspin3.Lock(False)
            self.sawspin3.SetDirection(-100)

            self.sawspin4 = self.GetHinge("saws_spin03")
            self.sawspin4.SetAutoLocks(False, True)
            self.sawspin4.SetPowerSettings(20, 1000)
            self.sawspin4.Lock(False)
            self.sawspin4.SetDirection(-100)

            self.sawspin5 = self.GetHinge("saws_spin04")
            self.sawspin5.SetAutoLocks(False, True)
            self.sawspin5.SetPowerSettings(20, 1000)
            self.sawspin5.Lock(False)
            self.sawspin5.SetDirection(-100)

            self.sawspin6 = self.GetHinge("saws_spin05")
            self.sawspin6.SetAutoLocks(False, True)
            self.sawspin6.SetPowerSettings(20, 1000)
            self.sawspin6.Lock(False)
            self.sawspin6.SetDirection(-100)

        else:
            pass
        
        return Arenas.SuperArena.HazardsOn(self, on)

    def Tick(self):
        # check to see if anyone has been "eliminated" by falling into a pit
        for each in self.players:
            if plus.getLocation(each)[1] < -8 and not plus.isEliminated(each):
                plus.eliminatePlayer(each)
                
        if self.bHazardsOn:

            #activate hazards
            self.Hell1.Tick()
            self.Hell2.Tick()
            self.Hell3.Tick()
            self.Hell4.Tick()
            self.Hell5.Tick()
            self.Hell6.Tick()
            self.Hell7.Tick()
            self.Hell8.Tick()
            self.spikes1.Tick()
            self.spikes2.Tick()
            self.Hammer1.Tick()
            self.Hammer2.Tick()
            self.Hammer3.Tick()
            self.Hammer4.Tick()

        return Arenas.SuperArena.Tick(self)

    def ZoneEvent(self, direction, id, robot, chassis):
        #if people are in zones then make the hazards do stuff
        if (id==1 and direction==1):
            self.Hell1.RaiseHell()
        elif (id==2 and direction==1):
            self.Hell2.RaiseHell()
        elif (id==3 and robot > 0):
            self.Hammer1.ZoneEvent(direction)
        elif (id==4 and robot > 0):
            self.Hammer2.ZoneEvent(direction)
        elif (id==5 and robot > 0):
            self.Hammer3.ZoneEvent(direction)
        elif (id==6 and robot > 0):
            self.Hammer4.ZoneEvent(direction)
        elif (id == 7 and direction==1):
            self.Hell3.RaiseHell()
        elif (id == 8 and direction==1):
            self.Hell4.RaiseHell()
        elif (id == 9 and direction==1):
            self.Hell5.RaiseHell()
        elif (id == 10 and direction==1):
            self.Hell6.RaiseHell()
        elif (id == 11 and direction==1):
            self.Hell7.RaiseHell()
        elif (id == 12 and direction==1):
            self.Hell8.RaiseHell()
        elif (id == 13):
            # entering spikes zone 1
            self.spikes1.ZoneEvent(direction)
        elif (id == 14):
            # entering spikes zone 1
            self.spikes2.ZoneEvent(direction)

        return True
        
Arenas.register(ClawTop)
